/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.client.particle;

import com.renyigesai.immortalers_delight.client.particle.SnowFogParticleOption;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SnowFogParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final double radius;
    private double angularSpeed;
    private double initialAngle;
    private int extra_radius;

    public static SnowFogParticleProvider snowFogParticleProvider(SpriteSet spriteSet) {
        return new SnowFogParticleProvider(spriteSet);
    }

    protected SnowFogParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet, int ex_radius) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.m_107250_(0.3f, 0.3f);
        this.f_107663_ *= 5.0f;
        this.f_107225_ = 53;
        this.f_107226_ = -0.45f;
        this.f_107219_ = false;
        this.f_107215_ = vx * 1.0;
        this.f_107216_ = vy * 1.0;
        this.f_107217_ = vz * 1.0;
        this.radius = 1.0;
        this.extra_radius = ex_radius;
        this.angularSpeed = 0.35;
        this.initialAngle = Math.random() * Math.PI * 2.0;
        this.m_108335_(spriteSet);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        if (this.f_107224_ % 5 == 0) {
            this.f_107226_ *= -1.0f;
        }
        if (!this.f_107220_) {
            this.angularSpeed = this.f_107224_ <= 10 ? (this.angularSpeed *= 0.9) : (this.angularSpeed *= 0.99);
        }
        super.m_5989_();
    }

    public float getRadius(float pScaleFactor) {
        float animation = Mth.m_14036_((float)(((float)this.f_107224_ + pScaleFactor) / (float)this.f_107225_ * 0.75f), (float)0.0f, (float)1.0f);
        return (float)(this.radius + (double)(animation * (float)this.extra_radius));
    }

    public int m_6355_(float pPartialTick) {
        return 240;
    }

    protected void m_107275_() {
        AABB aabb = this.m_107277_();
        double Cx = (aabb.f_82288_ + aabb.f_82291_) / 2.0;
        double Cy = aabb.f_82289_;
        double Cz = (aabb.f_82290_ + aabb.f_82293_) / 2.0;
        double currentAngle = this.initialAngle + this.angularSpeed * (double)this.f_107224_;
        double xOffset = (double)this.getRadius(0.5f) * Math.cos(currentAngle);
        double zOffset = (double)this.getRadius(0.5f) * Math.sin(currentAngle);
        this.f_107212_ = Cx + xOffset;
        this.f_107213_ = Cy;
        this.f_107214_ = Cz + zOffset;
    }

    public static class SnowFogParticleProvider
    implements ParticleProvider<SnowFogParticleOption> {
        private final SpriteSet spriteSet;

        public SnowFogParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SnowFogParticleOption typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SnowFogParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, typeIn.getCountdown());
        }
    }
}

